import React, {PureComponent} from 'react';
import B from 'bem-cn-lite';

import {connect} from 'react-redux';

import {YBUS} from '../../lib/segments/tariffSources';

import IconGlyph from '../../interfaces/components/IconGlyph';

import getAbsoluteUrlForStaticFromBackend from '../../lib/url/getAbsoluteUrlForStaticFromBackend';

import Modal from '../basic/Modal';
import Icon from '../Icon/Icon';
import TimeAndStationsModal from './TimesAndStationsModal';
import Price from '../Price/Price';
import SegmentBuyLink from '../SegmentBuyLink';

import keyset from '../../i18n/choose-partner';

export const b = B('ModalChoosePartner');

const mapStateToProps = ({environment}) => ({
    isProduction: environment.production,
});

class ModalChoosePartner extends PureComponent {
    getPartnerSegment(variant, key, segment) {
        const {isProduction} = this.props;

        const {supplier, price} = variant;

        const {logo} = supplier || {};
        const isYaBus = key === YBUS;

        return (
            <div className={b('partnerSegment')} key={key}>
                <div className={b('partnerImage')}>
                    {isYaBus ? (
                        <Icon
                            className={b('yabusIcon')}
                            glyph={IconGlyph.travelLogo}
                        />
                    ) : (
                        <img
                            className={b('partnerIcon')}
                            src={getAbsoluteUrlForStaticFromBackend(
                                logo,
                                isProduction,
                            )}
                            alt={keyset('partner-logo-alt')}
                        />
                    )}
                </div>
                <div className={b('priceBlock')}>
                    <Price className={b('price')} price={price} round />
                </div>

                <SegmentBuyLink
                    className={b('buyLink')}
                    segment={segment}
                    tariffClass={variant}
                >
                    <span>{keyset('buy')}</span>
                </SegmentBuyLink>
            </div>
        );
    }

    getPartnerSegments(variants, segment) {
        const partnerSegments = [];

        Object.entries(variants).forEach(([partnerKey, variant]) => {
            if (partnerKey === YBUS) {
                partnerSegments.unshift(
                    this.getPartnerSegment(variant, partnerKey, segment),
                );
            } else {
                partnerSegments.push(
                    this.getPartnerSegment(variant, partnerKey, segment),
                );
            }
        });

        return partnerSegments;
    }

    render() {
        const {tariffClass, segment, language, togglePartnerPicker} =
            this.props;

        const {
            arrivalMoment,
            departureMoment,
            stationTo,
            stationFrom,
            company,
        } = segment;

        const {variants} = tariffClass || {};

        const {title: companyTitle} = company;

        return (
            <div className={b()}>
                <Modal
                    visible
                    title={keyset('title')}
                    className={b()}
                    onClose={togglePartnerPicker}
                    mods={{alignOnTop: true}}
                >
                    <div className={b('contentBlock')}>
                        <div className={b('infoBlock')}>
                            <div className={b('scheduleAndPoints')}>
                                <TimeAndStationsModal
                                    className={b()}
                                    stationTo={stationTo}
                                    stationFrom={stationFrom}
                                    arrivalMoment={arrivalMoment}
                                    departureMoment={departureMoment}
                                    language={language}
                                />
                            </div>

                            <div className={b('company')}>
                                {keyset('company', {title: companyTitle})}
                            </div>
                        </div>

                        <div className={b('partnersBlock')}>
                            {this.getPartnerSegments(variants, segment)}
                        </div>
                    </div>
                </Modal>
            </div>
        );
    }
}

export default connect(mapStateToProps)(ModalChoosePartner);
