import {React, PureComponent, B, PropTypes} from '../base';

import {
    ROBOT,
    HUMAN_MONTH,
    HUMAN_MONTH_WITH_YEAR,
} from '../../lib/date/formats';

import {rangeToArray} from '../../lib/date/utils';
import noop from '../../lib/noop';

import CalendarDay from '../CalendarDay';
import Weekdays from '../Weekdays/Weekdays';

const b = B('Month');
const r = B('RedesignedMonth');

export default class Month extends PureComponent {
    static propTypes = {
        month: PropTypes.object.isRequired,
        language: PropTypes.string.isRequired,

        DayComponent: PropTypes.elementType,
        showMonthName: PropTypes.bool,
        showYear: PropTypes.bool,
        showWeekdays: PropTypes.bool,
        isRedesigned: PropTypes.bool,
        onClick: PropTypes.func,
        className: PropTypes.string,
    };

    static defaultProps = {
        DayComponent: CalendarDay,
        showYear: false,
        showMonthName: true,
        showWeekdays: false,
        onClick: noop,
        className: '',
    };

    render() {
        const {
            month,
            showYear,
            DayComponent,
            showMonthName,
            showWeekdays,
            language,
            className,
            ...props
        } = this.props;

        const days = rangeToArray(
            {
                start: month,
                end: month.clone().endOf('month'),
            },
            'day',
        );

        const startDay = `${month.weekday()}`;
        const cx = props.isRedesigned ? r : b;

        return (
            <div className={cx({startDay}, className)}>
                {showMonthName && (
                    <div className={cx('name')}>
                        {month.format(
                            showYear ? HUMAN_MONTH_WITH_YEAR : HUMAN_MONTH,
                        )}
                    </div>
                )}

                {showWeekdays && <Weekdays language={language} />}

                <div className={cx('days')}>
                    {days.map(day => (
                        <DayComponent
                            {...props}
                            day={day}
                            language={language}
                            key={day.format(ROBOT)}
                        />
                    ))}
                </div>
            </div>
        );
    }
}
