import {React, PureComponent, B, PropTypes} from '../base';

import {momentTimezone as moment} from '../../../reexports';

import {rangeToArray} from '../../lib/date/utils';
import {
    ROBOT,
    HUMAN_MONTH,
    HUMAN_MONTH_WITH_YEAR,
} from '../../lib/date/formats';

import Weekdays from '../Weekdays/Weekdays';
import CalendarDay from '../CalendarDay';

const b = B('Month');

export default class Month extends PureComponent {
    static propTypes = {
        month: PropTypes.instanceOf(moment).isRequired,

        DayComponent: PropTypes.elementType,
        showYear: PropTypes.bool,
    };

    static defaultProps = {
        DayComponent: CalendarDay,
        showYear: false,
    };

    render() {
        const {month, showYear, DayComponent, ...props} = this.props;

        const days = rangeToArray(
            {
                start: month,
                end: month.clone().endOf('month'),
            },
            'day',
        );

        const startDay = `${month.weekday()}`;

        return (
            <div className={b({startDay})}>
                <div className={b('name')}>
                    {month.format(
                        showYear ? HUMAN_MONTH_WITH_YEAR : HUMAN_MONTH,
                    )}
                </div>

                <Weekdays language={props.language} />

                <div className={b('days')}>
                    {days.map(day => (
                        <DayComponent
                            {...props}
                            day={day}
                            key={day.format(ROBOT)}
                        />
                    ))}
                </div>
            </div>
        );
    }
}
