import React, {ReactElement, memo} from 'react';
import B from 'bem-cn-lite';

const b = B('MoreButton');

interface IMoreButton {
    onClick: () => void;

    size?: 's';
    className?: string;
}

export default memo(MoreButton);

function MoreButton({
    onClick,

    size = 's',
    className,
}: IMoreButton): ReactElement {
    return (
        <div className={b({size}, className)} onClick={onClick}>
            <span className={b('dot')} />
            <span className={b('dot')} />
            <span className={b('dot')} />
        </div>
    );
}
