import React, {memo, useEffect, useRef} from 'react';
import B from 'bem-cn-lite';
import {v4 as uuid} from 'uuid';

const b = B('NativeDirectBlock');

interface INativeDirectBlockParams {
    id: string;

    className?: string;
}

export default memo(NativeDirectBlock);

function NativeDirectBlock({
    id,

    className,
}: INativeDirectBlockParams): React.ReactElement {
    const blockRef = useRef<HTMLDivElement | null>(null);

    useEffect(() => {
        const blockElement = blockRef.current;

        if (!blockElement) {
            return;
        }

        // Генерируем id блока и присваиваем его элементу
        const blockId = `native-direct-${id}-${uuid()}`;

        blockElement.id = blockId;

        window.yaContextCb.push(() => {
            if (!window.Ya) {
                return;
            }

            window.Ya.Context.AdvManager.renderWidget({
                blockId: id,
                renderTo: blockId,
            });
        });
    }, [id]);

    return <div className={b({}, className)} ref={blockRef} />;
}
