import React, {ReactElement, memo, PropsWithChildren, useMemo} from 'react';
import B from 'bem-cn-lite';

const b = B('NativeHorizontScroll');

interface INativeHorizontScroll {
    className?: string;
    withSideGradient?: boolean;
    sideGradientWidth?: number;
    leftSideGradientWidth?: number;
    rightSideGradientWidth?: number;
}

export default memo(NativeHorizontScroll);

// Скрывает нижнюю полосу прокрутки за счет отрицательного margin
function NativeHorizontScroll({
    children,
    className,
    withSideGradient,
    sideGradientWidth = 12,
    leftSideGradientWidth = sideGradientWidth,
    rightSideGradientWidth = sideGradientWidth,
}: PropsWithChildren<INativeHorizontScroll>): ReactElement {
    const sideGradient = useMemo(() => {
        if (!withSideGradient) {
            return null;
        }

        return (
            <>
                <div
                    className={b('leftGradient')}
                    style={{
                        width: leftSideGradientWidth,
                        background:
                            'linear-gradient(to left, transparent, currentColor)',
                    }}
                />

                <div
                    className={b('rightGradient')}
                    style={{
                        width: rightSideGradientWidth,
                        background:
                            'linear-gradient(to right, transparent, currentColor)',
                    }}
                />
            </>
        );
    }, [leftSideGradientWidth, rightSideGradientWidth, withSideGradient]);

    return (
        <div className={b(undefined, className)}>
            {sideGradient}
            <div className={b('content')}>{children}</div>
        </div>
    );
}
