import React from 'react';
import B from 'bem-cn-lite';

import {IWithClassName} from '../../interfaces/components/IWithClassName';

import loaderKeyset from '../../i18n/loader';

interface IOverlayProps extends IWithClassName {
    isVisible: boolean;
}

const b = B('Overlay');

const LOADER_STYLE = {
    backgroundImage: `url(${process.env.IMAGES_PATH}/loader.gif)`,
};

const Overlay: React.FC<IOverlayProps> = ({isVisible, className}) => (
    <div className={b({visible: isVisible}, className)}>
        <div className={b('container')}>
            <div
                className={b('loader')}
                style={isVisible ? LOADER_STYLE : undefined}
            />

            <div className={b('loaderTitle')}>{loaderKeyset('title')}</div>
        </div>
    </div>
);

export default Overlay;
