import React from 'react';

import logger from '../../../client/logger';

import Error500 from '../Error500/Error500';

interface IPageErrorBoundaryState {
    hasError: boolean;
}

class PageErrorBoundary extends React.Component<any, IPageErrorBoundaryState> {
    static getDerivedStateFromError(): IPageErrorBoundaryState {
        return {hasError: true};
    }

    state = {hasError: false};

    componentDidCatch(error: Error, info: React.ErrorInfo): void {
        logger.error(info.componentStack, error, {
            message: `Ошибка рендера: ${error.message}`,
        });
    }

    render(): React.ReactNode {
        if (this.state.hasError) {
            return <Error500 />;
        }

        return this.props.children;
    }
}

export default PageErrorBoundary;
