import React from 'react';
import B from 'bem-cn-lite';

import TPointSuggestItem from '../../interfaces/components/PointSuggest/TPointSuggestItem';
import TPointSuggestCallback from '../../interfaces/components/PointSuggest/TPointSuggestCallback';

const b = B('PointInput');

interface IPointInputProps {
    value: TPointSuggestItem;
    name: string;
    onChange: TPointSuggestCallback;
    id: string;
    placeholder: string;

    autoFocus?: boolean;
    onKeyDown?: (event: React.KeyboardEvent<HTMLInputElement>) => void;
    onFocus?: () => void;
    onBlur?: () => void;
}

interface IPointInputState {
    value: TPointSuggestItem;
}

export default class PointInput extends React.PureComponent<
    IPointInputProps,
    IPointInputState
> {
    state: IPointInputState = {
        value: this.props.value,
    };

    inputRef = React.createRef<HTMLInputElement>();

    componentWillReceiveProps({value}): void {
        this.setState({value});
    }

    onChange = (e: React.ChangeEvent<HTMLInputElement>): void => {
        const data = {
            value: {
                title: e.target.value,
            },
        };

        this.setState(data);
        this.props.onChange(e, data);
    };

    triggerLeaveFocus(): void {
        setTimeout(() => this.inputRef.current?.blur());
    }

    render(): React.ReactElement {
        const {value} = this.state;
        const {onKeyDown, onFocus, onBlur, id, name, placeholder, autoFocus} =
            this.props;

        return (
            <span className={b()}>
                <input
                    className={b('title')}
                    id={id}
                    type="text"
                    name={name}
                    value={value.title}
                    placeholder={placeholder}
                    autoFocus={autoFocus}
                    autoComplete="off"
                    ref={this.inputRef}
                    onChange={this.onChange}
                    onKeyDown={onKeyDown}
                    onFocus={onFocus}
                    onBlur={onBlur}
                />
            </span>
        );
    }
}
