import React from 'react';
import B from 'bem-cn-lite';

import TSuggestItemFromBackend from '../../interfaces/lib/suggests/TSuggestItemFromBackend';
import TPointSuggestCallback from '../../interfaces/components/PointSuggest/TPointSuggestCallback';

import PointSuggestItem from '../PointSuggestItem/PointSuggestItem';

const b = B('PointSuggestDrop');

interface IPointSuggestDrop {
    items: TSuggestItemFromBackend[];
    selectedItemIndex: number;
    onItemClick: TPointSuggestCallback;
    onItemMouseOver: TPointSuggestCallback;

    paddingSides?: number;
    className?: string;
}

export default React.memo(PointSuggestDrop);

function PointSuggestDrop({
    items,
    selectedItemIndex,
    onItemClick,
    onItemMouseOver,
    className,
    paddingSides,
}: IPointSuggestDrop): React.ReactElement {
    return (
        <ul className={b({}, className)}>
            {items.map((item, index) => (
                <PointSuggestItem
                    {...item}
                    key={item.value.key}
                    selected={index === selectedItemIndex}
                    onClick={onItemClick}
                    onMouseOver={onItemMouseOver}
                    paddingSides={paddingSides}
                />
            ))}
        </ul>
    );
}
