import React from 'react';
import B from 'bem-cn-lite';

import TPointSuggestCallback from '../../interfaces/components/PointSuggest/TPointSuggestCallback';
import TSuggestItemFromBackend from '../../interfaces/lib/suggests/TSuggestItemFromBackend';

const b = B('PointSuggestItem');

interface IPointSuggestItemProps {
    text: TSuggestItemFromBackend['text'];
    value: TSuggestItemFromBackend['value'];
    onClick: TPointSuggestCallback;
    onMouseOver: TPointSuggestCallback;
    selected: boolean;

    paddingSides?: number;
}

export default class PointSuggestItem extends React.PureComponent<IPointSuggestItemProps> {
    onClick = (e): void => {
        this.props.onClick(e, {value: this.props.value});
    };

    onMouseOver = (e): void => {
        this.props.onMouseOver(e, {value: this.props.value});
    };

    onMouseDown(e): void {
        e.preventDefault();
    }

    render(): React.ReactElement {
        const {selected, text, paddingSides} = this.props;

        return (
            <li
                className={b({selected, paddingSides})}
                onClick={this.onClick}
                onMouseOver={this.onMouseOver}
                onMouseDown={this.onMouseDown}
            >
                {text}
            </li>
        );
    }
}
