import React, {memo, useEffect} from 'react';
import B from 'bem-cn-lite';

import formatPrice from '../../lib/format/formatPrice';

import IPrice from 'common/interfaces/state/IPrice';

const b = B('Price');

export interface IPriceProps {
    price: IPrice;

    round?: boolean;
    /* Добавляет "от" */
    from?: boolean;
    /* Возможность вставить строку или елемент перед ценой */
    prefix?: string | React.ReactNode;
    onShow?: () => void;
    className?: string;
}

export default memo(Price);

function Price({
    price,

    round,
    from,
    prefix,
    onShow,
    className,
}: IPriceProps): React.ReactElement {
    useEffect(() => {
        if (onShow) {
            onShow();
        }
    }, [onShow]);

    return (
        <span className={b({}, className)}>
            {prefix && <span className={b('prefix')}>{prefix}</span>}
            {formatPrice(price, {from, round})}
        </span>
    );
}
