import React, {useCallback} from 'react';
import B from 'bem-cn-lite';

import {reachGoal} from '../../lib/yaMetrika';

import IconGlyph from '../../interfaces/components/IconGlyph';
import {IWithClassName} from '../../interfaces/components/IWithClassName';

import Icon from '../Icon/Icon';
import ButtonLink from '../ButtonLink/ButtonLink';

import printKeyset from '../../i18n/print-button';

interface IPrintButtonProps extends IWithClassName {
    compact?: boolean;
}

const b = B('PrintButton');

const PrintButton: React.FC<IPrintButtonProps> = ({className, compact}) => {
    const handlePrint = useCallback(() => {
        reachGoal('print_click');
        window.print();
    }, []);

    const title = printKeyset('title');

    return (
        <ButtonLink
            className={b({}, className)}
            theme="textSecondary"
            onClick={handlePrint}
        >
            <figure className={b('iconFigure', {compact})} aria-label={title}>
                <Icon className={b('icon')} glyph={IconGlyph.printIcon} />
            </figure>

            {!compact && title}
        </ButtonLink>
    );
};

export default PrintButton;
