import React from 'react';
import B from 'bem-cn-lite';

import {makeCacheable} from '../../lib/cache';

const b = B('RadioGroup2');

interface IRadioButton {
    content: string | React.ReactElement;
}

interface IRadioGroup2<T extends IRadioButton> {
    buttons: T[];
    onChange: (button: T) => void;

    selectedButton?: T;
}

const getOnButtonClick = makeCacheable(
    <T extends IRadioButton>(
            button: T,
            onChange: IRadioGroup2<T>['onChange'],
        ) =>
        () => {
            onChange(button);
        },
);

export default function RadioGroup2<T extends IRadioButton>({
    buttons,
    onChange,
    selectedButton,
}: IRadioGroup2<T>): React.ReactElement {
    return (
        <div className={b()}>
            {buttons.map((button, index) => {
                const {content} = button;
                const isSelected = button === selectedButton;

                return (
                    <button
                        key={index}
                        className={b('button', {selected: isSelected})}
                        onClick={getOnButtonClick(button, onChange)}
                    >
                        {content}
                    </button>
                );
            })}
        </div>
    );
}
