import React, {memo} from 'react';
import {Moment} from 'moment';
import B from 'bem-cn-lite';

import {HUMAN_SHORT} from '../../lib/date/formats';

import Platform from '../../interfaces/Platform';
import ExpValues from '../../interfaces/state/flags/ExpValues';
import DateSpecialValue from '../../interfaces/date/DateSpecialValue';

import useSelector from '../useSelector';
import {useFlags} from '../../hooks/useFlags';
import getRailwayTime from '../../lib/date/getRailwayTime';
import isAllDaysSearch from '../../lib/search/isAllDaysSearch';

const isMobile = process.env.PLATFORM === Platform.mobile;

const b = B('RailwayTime');

export interface IRailwayTimeProps {
    timeMoment: Moment;

    showDate?: boolean;
    className?: string;
    railwayMoment?: Moment;
    railwayTimezone?: string;
    when?: {
        special?: DateSpecialValue;
    };
}

export default memo(RailwayTime);

function RailwayTime({
    timeMoment,

    className = '',
    showDate,
    railwayMoment,
    railwayTimezone,
    when,
}: IRailwayTimeProps): React.ReactElement | null {
    const railwayTime = getRailwayTime({
        isAllDaysSearch: isAllDaysSearch({when}),
        timeMoment,
        railwayMoment,
        railwayTimezone,
    });
    const isValid = timeMoment.isValid();

    const user = useSelector(state => state.user);
    const flags = useFlags();

    if (
        flags.hideMoscowTime === ExpValues.experiment ||
        flags.hideMoscowTime ||
        user.isBot
    ) {
        return null;
    }

    if (!railwayTime && !showDate) {
        return null;
    }

    return (
        <span
            className={b({}, className)}
            aria-label={(railwayTime && railwayTime.title) || ''}
            data-nosnippet
        >
            {isMobile && showDate && isValid && (
                <span className={b('date')}>
                    {timeMoment.format(HUMAN_SHORT)}
                    {railwayTime && ' | '}
                </span>
            )}

            {railwayTime && railwayTime.time}
        </span>
    );
}
