import {React, Component, B, mix} from '../base';

import RailwayTime from '../RailwayTime/RailwayTime';

const b = B('RailwayTimes');

class RailwayTimes extends Component {
    render() {
        const {when, segment, showDepartureDate, showArrivalDate, className} =
            this.props;
        const {
            stationFrom,
            departureMoment,
            departureRailwayMoment,

            stationTo,
            arrivalMoment,
            arrivalRailwayMoment,
        } = segment;

        return (
            <div className={mix(b(), className)}>
                <RailwayTime
                    className={b('departure')}
                    timeMoment={departureMoment}
                    railwayMoment={departureRailwayMoment}
                    railwayTimezone={stationFrom.railwayTimezone}
                    showDate={showDepartureDate}
                    when={when}
                />

                <RailwayTime
                    className={b('arrival')}
                    timeMoment={arrivalMoment}
                    railwayMoment={arrivalRailwayMoment}
                    railwayTimezone={stationTo.railwayTimezone}
                    showDate={showArrivalDate}
                    when={when}
                />
            </div>
        );
    }
}

export default RailwayTimes;
