import React, {ReactElement, memo} from 'react';
import B from 'bem-cn-lite';

import InformerTheme from '../../interfaces/components/informer/InformerTheme';
import IconGlyphInformers from '../../interfaces/components/IconGlyphInformers';

import Link from '../Link';
import Icon from '../Icon/Icon';

import informerKeyset from '../../i18n/informers';

const b = B('RaspLink');

interface IRaspLinkParams {
    href: string;

    theme?: InformerTheme;
}

export default memo(RaspLink);

function RaspLink({
    href,

    theme,
}: IRaspLinkParams): ReactElement {
    return (
        <Link
            href={href}
            target="_blank"
            colors={theme === InformerTheme.black ? 'textPrimary' : undefined}
            className={b()}
        >
            <Icon
                className={b('icon')}
                glyph={IconGlyphInformers.serviceDescription}
            />

            {informerKeyset('main-page-link')}
        </Link>
    );
}
