import {React, Component, PropTypes, B, mix} from '../base';

const b = B('RecommendationWidget');

let promiseScriptLoading = null;
let pageCounter = 1;

export default class RecommendationWidget extends Component {
    static propTypes = {
        blockId: PropTypes.string.isRequired,
        className: PropTypes.string,
    };

    state = {
        pageNumber: null,
        mounted: false,
    };

    componentDidMount() {
        this.setState({
            pageNumber: pageCounter++,
            mounted: true,
        });
    }

    componentDidUpdate() {
        this.loadAndRender();
    }

    loadAndRender() {
        promiseScriptLoading = (
            promiseScriptLoading ||
            new Promise(resolve => {
                (function (document) {
                    const target = document.getElementsByTagName('script')[0];
                    const script = document.createElement('script');

                    script.type = 'text/javascript';
                    script.src =
                        'https://yastatic.net/pcode-native/loaders/loader.js';
                    script.async = true;
                    script.onload = resolve;
                    target.parentNode.insertBefore(script, target);
                })(window.document);
            })
        ).then(this.renderWidget);
    }

    getContainerId() {
        return `id-${this.props.blockId}-${this.state.pageNumber}`;
    }

    renderWidget = () => {
        const {blockId} = this.props;

        window.yaContextCb.push(() => {
            if (!window.Ya) {
                return;
            }

            window.Ya.Context.AdvManager.renderWidget({
                blockId,
                renderTo: this.getContainerId(),
            });
        });
    };

    render() {
        const {className} = this.props;
        const {mounted} = this.state;

        return (
            <div
                className={mix(b(), className)}
                {...(mounted ? {id: this.getContainerId()} : {})}
            />
        );
    }
}
