import {PureComponent} from '../base';

import IconGlyph from '../../interfaces/components/IconGlyph';

import {reachGoal} from '../../lib/yaMetrika';
import addUtmTagsToEdemRfUrl from '../../lib/url/addUtmTagsToEdemRfUrl';

import blablacarKeyset from '../../i18n/blablacar';
import edemRfKeyset from '../../i18n/edemRf';

export default class RidesharingSegment extends PureComponent {
    componentDidMount() {
        if (this.props.querying) {
            reachGoal('morda_blablacar_loading');
        } else {
            reachGoal('morda_blablacar_show');
        }
    }

    componentDidUpdate(oldProps) {
        if (oldProps.querying && !this.props.querying) {
            reachGoal('morda_blablacar_show');
        }
    }

    onTitleClick = () => {
        reachGoal('morda_blablacar_service-link_click');
    };

    onOffersClick = () => {
        reachGoal('morda_blablacar_offers-link_click');
    };

    onSearchClick = () => {
        reachGoal('morda_blablacar_price_click');
    };

    getBlaBlaCarOptions() {
        const {tariff} = this.props;
        const {orderUrl} = tariff || {};

        return {
            iconGlyph: IconGlyph.blablacar,
            ariaLabel: 'BlaBlaCar',
            url: orderUrl,
            cssModifier: 'blablacar',
            slogan: blablacarKeyset('description'),
            ageLimit: blablacarKeyset('ageLimit'),
        };
    }

    getEdemRfOptions() {
        const {tariff} = this.props;
        const {orderUrl} = tariff || {};

        return {
            iconGlyph: IconGlyph.edemRf,
            ariaLabel: edemRfKeyset('partnerName'),
            url: addUtmTagsToEdemRfUrl(orderUrl),
            cssModifier: 'edemRf',
            slogan: edemRfKeyset('slogan'),
        };
    }
}
