import React from 'react';
import B from 'bem-cn-lite';
import RidesharingSegmentBase from './base';

import convertPrice from '../../lib/currencies/convertPrice';

import Icon from '../Icon/Icon';
import Link from '../Link';
import Price from '../Price/Price';
import Duration from '../Duration/Duration';
import Spinner from '../Spinner/Spinner';

import keyset from '../../i18n/blablacar';

const b = B('RidesharingSegment');
const TEN_MINUTES = 600;

export default class RidesharingSegment extends RidesharingSegmentBase {
    render() {
        const {
            className,
            tariff,
            querying,
            allDaysCheckResult,
            allDaysCheckComplete,
            currencies,
        } = this.props;
        const {price, title = '', duration, offersCount} = tariff || {};

        const noResultsOnDate = !offersCount && Boolean(allDaysCheckResult);
        const showPrice = price && offersCount;

        const showWaiter = querying || (!offersCount && !allDaysCheckComplete);

        const roundedDuration = Math.ceil(duration / TEN_MINUTES) * TEN_MINUTES;
        const convertedPrice =
            price && currencies ? convertPrice(price, currencies) : price;
        const fullOffersTitle = keyset('offers-cars', {count: offersCount});

        const [fromTitle, toTitle] = title
            .split(' — ')
            .map(cityName => cityName.trim());
        const {iconGlyph, ariaLabel, cssModifier, url, slogan, ageLimit} =
            this.getBlaBlaCarOptions();

        return (
            <div className={b({[cssModifier]: true}, className)}>
                <div className={b('advertise')}>
                    {keyset('advertisement')} {ageLimit}
                </div>

                <div className={b('contentBlock')}>
                    <div className={b('titleBlock')}>
                        <Link
                            className={b('mainTitle')}
                            rel="nofollow"
                            href={url}
                            target="_blank"
                            onClick={this.onTitleClick}
                            aria-label={ariaLabel}
                        >
                            <Icon
                                className={b('serviceIcon')}
                                glyph={iconGlyph}
                            />
                        </Link>

                        <span className={b('description')}>{slogan}</span>
                    </div>

                    <div className={b('infoBlock')}>
                        <div className={b('directionBlock')}>
                            <div className={b('from')}>{fromTitle}</div>

                            {!noResultsOnDate && (
                                <Duration
                                    className={b('duration')}
                                    unit="seconds"
                                    duration={roundedDuration}
                                />
                            )}

                            <div className={b('to')}>{toTitle}</div>
                        </div>
                        {noResultsOnDate && (
                            <div className={b('noResults')}>
                                {keyset('no-results-on-date')}
                            </div>
                        )}
                    </div>

                    <div className={b('scheduleAndPrices')}>
                        {!noResultsOnDate && (
                            <Link
                                className={b('offers')}
                                rel="nofollow"
                                href={url}
                                target="_blank"
                                onClick={this.onOffersClick}
                            >
                                <span className={b('bigOffersTitle')}>
                                    {fullOffersTitle}
                                </span>
                            </Link>
                        )}

                        <Link
                            className={b('buyLink')}
                            rel="nofollow"
                            href={url}
                            target="_blank"
                            onClick={this.onSearchClick}
                        >
                            {showPrice ? (
                                <Price price={convertedPrice} from />
                            ) : (
                                keyset('details')
                            )}
                        </Link>
                    </div>
                    {showWaiter && (
                        <div className={b('waiter')}>
                            <Spinner className={b('spinner')} />

                            <span className={b('waiterTitle')}>
                                {keyset('inProcess')}
                            </span>
                        </div>
                    )}
                </div>
            </div>
        );
    }
}
