import {React, B} from '../base';
import RidesharingSegmentBase from './base';

import {momentTimezone as moment} from '../../../reexports';

import {humanizeDuration} from '../../lib/date/formats';
import convertPrice from '../../lib/currencies/convertPrice';

import Link from '../Link';
import Icon from '../Icon/Icon';
import Price from '../Price/Price';
import Spinner from '../Spinner/Spinner';

import keyset from '../../i18n/blablacar';

const b = B('RidesharingSegment');

export default class RidesharingSegment extends RidesharingSegmentBase {
    render() {
        const {
            tariff,
            querying,
            allDaysCheckResult,
            allDaysCheckComplete,

            className,
            currencies,
        } = this.props;

        const {price, duration, offersCount, title} = tariff || {};

        const noResultsOnDate = !offersCount && Boolean(allDaysCheckResult);
        const showPrice = Boolean(price && offersCount);

        const loaded =
            !querying && (Boolean(offersCount) || allDaysCheckComplete);

        const tenMinutes = 600;
        const roundedDuration = Math.ceil(duration / tenMinutes) * tenMinutes;
        const convertedPrice =
            price && currencies ? convertPrice(price, currencies) : price;
        const durationText = noResultsOnDate
            ? keyset('no-results-on-date')
            : `${humanizeDuration(
                  moment.duration(roundedDuration, 'seconds'),
              )} ${keyset('in-way')}`;
        const {iconGlyph, cssModifier, url, slogan, ageLimit} =
            this.getBlaBlaCarOptions();

        return (
            <div className={b({loaded, [cssModifier]: true}, className)}>
                <div className={b('header')}>
                    <div className={b('advertise')}>
                        {keyset('advertisement')} {ageLimit}
                    </div>

                    <div className={b('title')}>
                        <Link
                            className={b('logo')}
                            rel="nofollow"
                            href={url}
                            target="_blank"
                            onClick={this.onTitleClick}
                        >
                            <Icon className={b('icon')} glyph={iconGlyph} />
                        </Link>

                        <span className={b('titleDescription')}>{slogan}</span>
                    </div>
                </div>

                <div className={b('contentWrapper')}>
                    <div className={b('content')}>
                        <div>{title}</div>

                        <div className={b('duration')}>{durationText}</div>
                    </div>

                    <div className={b('waiter')}>
                        <Spinner className={b('spinner')} />

                        <span className={b('waiterTitle')}>
                            {keyset('inProcess')}
                        </span>
                    </div>
                </div>

                <div className={b('footer')}>
                    {showPrice && (
                        <Link
                            className={b('offers')}
                            rel="nofollow"
                            href={url}
                            target="_blank"
                            onClick={this.onOffersClick}
                        >
                            <Price price={convertedPrice} from />

                            <div>{keyset('offers', {count: offersCount})}</div>
                        </Link>
                    )}

                    <Link
                        className={b('details')}
                        rel="nofollow"
                        href={url}
                        target="_blank"
                        onClick={this.onSearchClick}
                    >
                        {keyset('details')}
                    </Link>
                </div>
            </div>
        );
    }
}
