import {React, PureComponent, B, mix} from '../base';

import doNotRenderUntil from '../_utils/doNotRenderUntil';

const b = B('Rollout');

class Rollout extends PureComponent {
    constructor(props) {
        super(props);

        this.state = {
            visible: props.initiallyRendered && props.visible,
        };
    }

    componentDidMount() {
        if (this.props.visible) {
            setTimeout(() => {
                this.setState({visible: true});
            }, 0);
        }
    }

    componentWillReceiveProps({visible}) {
        this.setState({visible});
    }

    render() {
        const {children, className} = this.props;
        const {visible} = this.state;

        return <div className={mix(b({visible}), className)}>{children}</div>;
    }
}

Rollout.defaultProps = {
    visible: false,
};

export default doNotRenderUntil(Rollout);
