import {createContext, ReactNode} from 'react';

import Mods from '../../interfaces/components/Mods';

import noop from '../../lib/noop';

interface IRootContext {
    readonly bodyFixed: boolean;
    fixBody(): void;
    releaseBody(): void;
    readonly popupIsOpened: boolean;
    readonly popupContent: ReactNode;
    readonly popupMods: Mods;
}

const RootContext = createContext<IRootContext>({
    bodyFixed: false,
    fixBody: noop,
    releaseBody: noop,
    popupIsOpened: false,
    popupContent: null,
    popupMods: {},
});

export default RootContext;

export const RootContextProvider = RootContext.Provider;
