import React, {ReactElement} from 'react';
import moment from 'moment';
import B from 'bem-cn-lite';
import ReactDOMServer from 'react-dom/server';
import upperFirst from 'lodash/upperFirst';

import {COUNTER_CODE} from '../../lib/informer/constants';

import IRootInformers from '../../interfaces/components/IRootInformers';

import getSearchTitle from './getSearchTitle';
import getInformerMetrika from '../../../server/helpers/counters/getInformerMetrika';

import SearchInformerMobile from '../SearchInformer/SearchInformer.mobile';
import SearchInformerDesktop from '../SearchInformer/SearchInformer.desktop';
import StationInformerMobile from '../StationInformer/StationInformer.mobile';
import StationInformerDesktop from '../StationInformer/StationInformer.desktop';

const b = B('RootInformers');

export function RootInformers({
    hostForInformerBundle,
    svgSprite,
    nonce,

    dataForSearchInformer,
    dataForStationInformer,
}: IRootInformers): ReactElement {
    let title = '';

    if (dataForSearchInformer) {
        const {pointFrom, pointTo, transportType, dateMomentOnStationFrom} =
            dataForSearchInformer;

        title = getSearchTitle(
            pointFrom,
            pointTo,
            transportType,
            dateMomentOnStationFrom,
        );
    }

    if (dataForStationInformer) {
        const {title: stationTitle, fullTitle} =
            dataForStationInformer.stationData;

        title = upperFirst(fullTitle || stationTitle);
    }

    return (
        <html>
            <head>
                <title>{title}</title>
                <meta
                    name="viewport"
                    content="width=device-width, initial-scale=1, shrink-to-fit=no"
                />
                <link
                    rel="stylesheet"
                    href={`${hostForInformerBundle}/app.css`}
                />
            </head>

            <body className={b()}>
                <div
                    dangerouslySetInnerHTML={{
                        __html: getInformerMetrika({
                            counterCode: COUNTER_CODE,
                            nonce,
                        }),
                    }}
                    style={{display: 'none'}}
                />

                <div
                    className={b('svgBundle')}
                    dangerouslySetInnerHTML={{__html: svgSprite}}
                />

                {dataForSearchInformer && (
                    <div className={b('desktop')}>
                        <SearchInformerDesktop {...dataForSearchInformer} />
                    </div>
                )}

                {dataForSearchInformer && (
                    <div className={b('mobile')}>
                        <SearchInformerMobile {...dataForSearchInformer} />
                    </div>
                )}

                {dataForStationInformer && (
                    <div className={b('desktop')}>
                        <StationInformerDesktop {...dataForStationInformer} />
                    </div>
                )}

                {dataForStationInformer && (
                    <div className={b('mobile')}>
                        <StationInformerMobile {...dataForStationInformer} />
                    </div>
                )}
            </body>
        </html>
    );
}

export {moment, ReactDOMServer};
