import {Moment} from 'moment';

import {HUMAN} from '../../lib/date/formats';
import {CHAR_EM_DASH} from '../../lib/stringUtils';

import IPoint from '../../interfaces/state/searchForm/IPoint';
import {FilterTransportType} from '../../lib/transportType';

import insertMarkupIntoKey from '../../i18n/_utils/insertMarkupIntoKey';

import informerKeyset from '../../i18n/informers';

export default function getSearchTitle(
    pointFrom: IPoint,
    pointTo: IPoint,
    transportType: FilterTransportType,
    dateMomentOnStationFrom: Moment,
): string {
    const date = dateMomentOnStationFrom.format(HUMAN);
    const fromTitle = pointFrom.popularTitle || pointFrom.title;
    const toTitle = pointTo.popularTitle || pointTo.title;
    const defaultTitle = `${fromTitle} ${CHAR_EM_DASH} ${toTitle}, ${date}`;

    const keysetParams = {
        fromTitleGenitive: pointFrom.titleGenitive || '',
        toPreposition: pointTo.preposition || false,
        toTitleAccusative: pointTo.titleAccusative || '',
    };

    const direction = informerKeyset('link-title', {...keysetParams});

    switch (transportType) {
        case FilterTransportType.all:
            return insertMarkupIntoKey(informerKeyset, 'all-title', {
                fromTitle,
                toTitle,
                date,
            });
        case FilterTransportType.bus:
            return insertMarkupIntoKey(informerKeyset, 'bus-title', {
                direction,
                date,
            });
        case FilterTransportType.plane:
            return insertMarkupIntoKey(informerKeyset, 'plane-title', {
                direction,
                date,
            });
        case FilterTransportType.suburban:
            return insertMarkupIntoKey(informerKeyset, 'suburban-title', {
                direction,
                date,
            });
        case FilterTransportType.train:
            return insertMarkupIntoKey(informerKeyset, 'train-title', {
                direction,
                date,
            });
        case FilterTransportType.water:
            return insertMarkupIntoKey(informerKeyset, 'water-title', {
                direction,
                date,
            });

        default:
            return defaultTitle;
    }
}
