import {React, PureComponent, B, bindMethods} from '../base';

import {reachGoalOnce} from '../../lib/yaMetrika';
import {updateSearchCalendarVisibility} from '../../actions/searchCalendar';
import {
    isSearchCalendarVisible,
    getSearchCalendarPageType,
} from '../../lib/searchCalendar';

import Button from '../Button/Button';
import Rollout from '../Rollout/Rollout';
import SearchCalendarSlider from '../SearchCalendarSlider/SearchCalendarSlider';

import calendarKeyset from '../../i18n/search-calendar';

const b = B('SearchCalendar');

export default class SearchCalendar extends PureComponent {
    constructor(props) {
        super(props);

        bindMethods(this, ['onTogglerClick']);
    }

    componentDidMount() {
        this.reachShowGoal(this.props);
    }

    componentWillUpdate(nextProps) {
        this.reachShowGoal(nextProps);
    }

    onTogglerClick() {
        const {dispatch, visibility} = this.props;

        const pageType = getSearchCalendarPageType(this.props);
        const visible = !visibility[pageType];

        if (visible) {
            reachGoalOnce('search_calendar_user_show');
        } else {
            reachGoalOnce('search_calendar_user_hide');
        }

        dispatch(updateSearchCalendarVisibility({[pageType]: visible}));
    }

    reachShowGoal(props) {
        if (isSearchCalendarVisible(props)) {
            reachGoalOnce('search_calendar_show');
        }
    }

    render() {
        const {context, segments, language, ...props} = this.props;

        const visible = isSearchCalendarVisible(this.props);

        return (
            <div className={b()}>
                <h3 className={b('title')}>{calendarKeyset('title')}</h3>

                <Button className={b('toggler')} onClick={this.onTogglerClick}>
                    {calendarKeyset(visible ? 'hide' : 'show')}
                </Button>

                <Rollout visible={visible}>
                    <SearchCalendarSlider
                        context={context}
                        language={language}
                        segments={segments}
                        {...props}
                    />
                </Rollout>
            </div>
        );
    }
}
