import {React, Component} from '../base';

import {connect} from 'react-redux';

import {HUMAN} from '../../lib/date/formats';

import searchUrl from '../../lib/url/searchUrl';
import {dayMatchesMask} from '../../lib/date/mask';
import {isDateInRange} from '../../lib/date/utils';

import CalendarDayLink from '../CalendarDayLink';

const mapStateToProps = ({tld, language}) => ({
    tld,
    language,
});

class SearchCalendarDayLink extends Component {
    render() {
        const {
            day,
            mask,
            today,
            range,
            context,
            sort,
            filtering,
            onClick,
            currencies,
            tld,
            language,
        } = this.props;

        let href;

        const inRange = isDateInRange(day, range);
        const inMask = dayMatchesMask(day, mask);

        if (inMask) {
            href = searchUrl(
                {
                    sort,
                    filtering,
                    context: {
                        ...context,
                        when: {text: day.format(HUMAN).toLowerCase()},
                    },
                    currencies,
                },
                tld,
                language,
            );
        }

        return (
            <CalendarDayLink
                day={day}
                href={href}
                today={today}
                inactive={!inMask}
                colorless={!inRange}
                onClick={onClick}
            />
        );
    }
}

export default connect(mapStateToProps)(SearchCalendarDayLink);
