import React, {ReactElement, memo} from 'react';
import B from 'bem-cn-lite';

import ITime from '../../../common/interfaces/state/searchForm/ITime';
import ISearchContext from '../../../common/interfaces/state/search/ISearchContext';
import ISearchSort from '../../../common/interfaces/state/search/ISearchSort';
import ISearchFiltering from '../../../common/interfaces/state/search/ISearchFiltering';
import IStateCurrencies from '../../../common/interfaces/state/IStateCurrencies';
import IStateSearchForm from '../../../common/interfaces/state/IStateSearchForm';
import SearchErrorPageType from '../../../common/interfaces/components/searchErrorPage/SearchErrorPageType';
import ISearchArchivalData from '../../../common/interfaces/state/search/ISearchArchivalData';

import TransportSelector from '../SearchHeader/components/TransportSelector/TransportSelector';

import useSelector from '../useSelector';

import DateHintsLinks from '../DateHintsLinks';
import SearchErrorBase from './SearchError.base';

const b = B('SearchErrorDesktop');

interface ISearchErrorDesktopProps {
    context: ISearchContext;
    type: SearchErrorPageType;

    sort?: ISearchSort;
    time?: ITime;
    plans?: object;
    filtering?: ISearchFiltering;
    currencies?: IStateCurrencies;
    searchForm?: IStateSearchForm;
    archivalData?: ISearchArchivalData;
}

export default memo(SearchErrorDesktop);

function SearchErrorDesktop({
    context,
    type,

    sort,
    filtering,
    currencies,
    time,
    plans,
    searchForm,
    archivalData,
}: ISearchErrorDesktopProps): ReactElement {
    const tld = useSelector(state => state.tld);
    const language = useSelector(state => state.language);

    return (
        <div className={b()}>
            {sort && filtering && currencies && (
                <TransportSelector
                    className={b('transportSelector')}
                    sort={sort}
                    context={context}
                    filtering={filtering}
                    currencies={currencies}
                    tld={tld}
                    language={language}
                />
            )}

            <SearchErrorBase
                type={type}
                context={context}
                sort={sort}
                searchForm={searchForm}
                archivalData={archivalData}
            />

            {type === SearchErrorPageType.noTickets && (
                <div className={b('dateHintsLinks')}>
                    <DateHintsLinks
                        context={context}
                        sort={sort}
                        time={time}
                        plans={plans}
                        filtering={filtering}
                        currencies={currencies}
                        isRedesigned
                    />
                </div>
            )}
        </div>
    );
}
