import React, {ReactElement, memo} from 'react';
import B from 'bem-cn-lite';

import ISearchContext from '../../../common/interfaces/state/search/ISearchContext';
import ISearchSort from '../../../common/interfaces/state/search/ISearchSort';
import IStateSearchForm from '../../../common/interfaces/state/IStateSearchForm';
import SearchErrorPageType from '../../../common/interfaces/components/searchErrorPage/SearchErrorPageType';
import ISearchArchivalData from '../../../common/interfaces/state/search/ISearchArchivalData';

import SearchErrorBase from './SearchError.base';

const b = B('SearchErrorMobile');

interface ISearchErrorMobileProps {
    context: ISearchContext;
    type: SearchErrorPageType;

    sort?: ISearchSort;
    searchForm?: IStateSearchForm;
    archivalData?: ISearchArchivalData;
}

export default memo(SearchErrorMobile);

function SearchErrorMobile({
    context,
    type,

    sort,
    searchForm,
    archivalData,
}: ISearchErrorMobileProps): ReactElement {
    return (
        <div className={b()}>
            <SearchErrorBase
                type={type}
                context={context}
                sort={sort}
                searchForm={searchForm}
                archivalData={archivalData}
                isMobile
            />
        </div>
    );
}
