import {React, PureComponent, B, mix} from '../base';

import {ALL_TYPE, SEARCHABLE_TRANSPORT_TYPES} from '../../lib/transportType';

import Button2 from '../Button2/Button2';
import TransportIcon from '../TransportIcon/TransportIcon';

import transportKeyset from '../../i18n/transport-types';

const b = B('Transports');

export default class Transports extends PureComponent {
    render() {
        const {className, searchForm, onSelect, language} = this.props;

        return (
            <div className={mix(b(), className)}>
                <div className={b('content')}>
                    {SEARCHABLE_TRANSPORT_TYPES.map(type => (
                        <Button2
                            key={type}
                            className={b('button', {
                                [type]: true,
                                selected: searchForm.transportType === type,
                            })}
                            name={type}
                            data-code={type}
                            onClick={onSelect(type)}
                        >
                            {type === ALL_TYPE ? (
                                transportKeyset('type-all')
                            ) : (
                                <TransportIcon
                                    language={language}
                                    showHint={false}
                                    transportType={type}
                                    colored={false}
                                />
                            )}
                        </Button2>
                    ))}
                </div>
            </div>
        );
    }
}
