import React, {useMemo} from 'react';

import {SEARCH} from '../../routes/search';

import Platform from '../../interfaces/Platform';

import {getCommonMask} from '../../lib/date/mask';
import isAllDaysSearch from '../../lib/search/isAllDaysSearch';

import useSelector from '../useSelector';

import Calendar from '../Calendar/Calendar';

const isMobile = process.env.PLATFORM === Platform.mobile;

const SearchFormCalendar = props => {
    const page = useSelector(state => state.page);
    const context = useSelector(state => state.search.context);
    const segments = useSelector(state => state.search.segments);
    const useMask =
        isMobile && isAllDaysSearch(context) && page.current === SEARCH;

    const mask = useMemo(() => {
        if (useMask) {
            return getCommonMask(segments);
        }
    }, [useMask, segments]);

    return <Calendar {...props} mask={mask} />;
};

export default SearchFormCalendar;
