import React, {useCallback, useState} from 'react';
import {batch} from 'react-redux';
import B from 'bem-cn-lite';

import IconGlyph from '../../interfaces/components/IconGlyph';

import {reachGoal} from '../../lib/yaMetrika';

import {setWhen, submitForm} from '../../actions/searchForm';

import useSelector from '../useSelector';
import useDispatch from '../useDispatch';
import {useFlags} from '../../hooks/useFlags';

import Button2 from '../Button2/Button2';
import Calendar from '../Calendar/Calendar.mobile';
import Icon from '../Icon/Icon';

const b = B('SearchFormDateButton');

const SearchFormDateButton: React.FC = () => {
    const [isCalendarVisible, setCalendarVisible] = useState(false);

    const dispatch = useDispatch();

    const language = useSelector(state => state.language);
    const flags = useFlags();
    const {time, when} = useSelector(state => state.searchForm);
    const {context} = useSelector(state => state.search);

    const handleSelectDateClick = useCallback(() => {
        reachGoal('search_form_open_datepicker_click');
        setCalendarVisible(true);
    }, [setCalendarVisible]);

    const handleCalendarDateChange = useCallback(
        (e, {value}) => {
            reachGoal('search_form_select_date_button_click');
            // ModalHistoryWrapper делает history.replaceState на unmount,
            // а submitForm  делает history.pushState,
            // чтобы небыло конфликтов при работе с историей нужен таймаут
            setTimeout(() => {
                batch(() => {
                    dispatch(setWhen(value));
                    dispatch(submitForm());
                });
            });
        },
        [dispatch],
    );

    const handleCalendarClose = useCallback(() => {
        setCalendarVisible(false);
    }, [setCalendarVisible]);

    return (
        <div className={b()}>
            <Button2
                sizeMod="filterButton"
                onClick={handleSelectDateClick}
                className={b('calendarButton')}
                iconRight={
                    <Icon
                        glyph={IconGlyph.calendarSmall}
                        className={b('calendarIcon')}
                    />
                }
            >
                {when.shortFormatted || when.formatted}
            </Button2>

            <Calendar
                time={time}
                value={when}
                fixed={false}
                context={context}
                opened={isCalendarVisible}
                language={language}
                onClose={handleCalendarClose}
                onChange={handleCalendarDateChange}
                flags={flags}
            />
        </div>
    );
};

export default SearchFormDateButton;
