import {React, PureComponent, B, bindMethods} from '../base';

import IconGlyph from '../../interfaces/components/IconGlyph';

import {reachGoal} from '../../lib/yaMetrika';

import {
    setFromPointFromUser,
    setToPointFromUser,
} from '../../actions/searchForm';
import {favoriteSearchHistoryItem} from '../../actions/searchHistory';

import Icon from '../Icon/Icon';

const b = B('SearchFormHint');

export default class SearchFormHint extends PureComponent {
    constructor(props) {
        super(props);
        bindMethods(this, [
            'makeFavoriteRef',
            'onFavoriteChange',
            'onHintButtonClick',
        ]);
    }

    onHintButtonClick() {
        const {value, dispatch} = this.props;
        const {from, to} = value;

        dispatch(setFromPointFromUser(from));
        dispatch(setToPointFromUser(to));
        reachGoal('search_hints_station_hint_click');
    }

    onFavoriteChange() {
        const favorite = this._favorite.checked;

        this.props.dispatch(
            favoriteSearchHistoryItem({
                searchContext: this.props.value,
                favorite,
            }),
        );
        reachGoal(
            `search_hints_station_hint_${favorite ? '' : 'un'}favorite_click`,
        );
    }

    makeFavoriteRef(node) {
        this._favorite = node;
    }

    getHintText(value) {
        return `${value.from.title} – ${value.to.title}`;
    }

    render() {
        const {value, favorite, canFavorite} = this.props;
        let favoriteElement;

        if (canFavorite) {
            favoriteElement = (
                <span className={b('favoriteButton')}>
                    <input
                        ref={this.makeFavoriteRef}
                        checked={favorite}
                        type="checkbox"
                        onChange={this.onFavoriteChange}
                    />

                    <Icon
                        className={b('icon', {favorite})}
                        glyph={
                            favorite
                                ? IconGlyph.favoriteFilled
                                : IconGlyph.favorite
                        }
                    />
                </span>
            );
        }

        return (
            <span className={b()}>
                {favoriteElement}

                <button
                    type="button"
                    className={b('hintButton')}
                    onClick={this.onHintButtonClick}
                >
                    {this.getHintText(value)}
                </button>
            </span>
        );
    }
}
