import React from 'react';
import B from 'bem-cn-lite';

import ISearchContext from '../../interfaces/state/search/ISearchContext';
import SearchSegment from '../../interfaces/state/search/SearchSegment';

import ServiceDescription from '../ServiceDescription';
import SearchHeaderDisclaimers from '../SearchHeaderDisclaimers/SearchHeaderDisclaimers';

const b = B('SearchHeader');

interface ISearchHeaderProps {
    context: ISearchContext;
    segments: SearchSegment[];
    hasDescription: boolean;
}

const SearchHeader: React.FC<ISearchHeaderProps> = props => (
    <div className={b()}>
        {props.hasDescription && <ServiceDescription />}

        <SearchHeaderDisclaimers
            className={b('disclaimers')}
            context={props.context}
            segments={props.segments}
        />
    </div>
);

export default SearchHeader;
