import React, {useCallback, useMemo} from 'react';
import upperFirst from 'lodash/upperFirst';
import B from 'bem-cn-lite';

import IconGlyph from '../../../../interfaces/components/IconGlyph';
import ISearchSort from '../../../../interfaces/state/search/ISearchSort';

import {reachGoal} from '../../../../lib/yaMetrika';
import {getSortFieldOptions} from '../../../../lib/sort/utils';

import useDispatch from '../../../useDispatch';
import {updateSorting} from '../../../../actions/search/sorting';

import Icon from '../../../Icon/Icon';
import Button2 from '../../../Button2/Button2';
import Select from '../../../basic/Select/Select';

interface ISortingProps {
    sort: ISearchSort;
}

const b = B('Sorting');

const Sorting: React.FC<ISortingProps> = ({sort}) => {
    const dispatch = useDispatch();
    const sortOptions = useMemo(
        () =>
            getSortFieldOptions().map(item => ({
                value: item.value,
                title: upperFirst(item.title),
            })),
        [],
    );
    const sortValue = sortOptions.find(({value}) => value === sort.by);

    const handleDirectionChange = useCallback(() => {
        dispatch(
            updateSorting({
                by: sort.by,
                reverse: !sort.reverse,
            }),
        );
        reachGoal('sorting_order_click');
    }, [sort, dispatch]);

    const handleTypeChange = useCallback(
        (option: {value: string; title: string}) => {
            dispatch(
                updateSorting({
                    by: option.value,
                    reverse: false,
                }),
            );
        },
        [dispatch],
    );

    const handleSortTypeClick = useCallback(() => {
        reachGoal('sorting_title_click');
    }, []);

    return (
        <>
            <Button2
                className={b('directionButton')}
                onClick={handleDirectionChange}
            >
                <Icon
                    className={b('directionIcon', {desc: sort.reverse})}
                    glyph={IconGlyph.sortDirection}
                />
            </Button2>

            <Select
                className={b('typeButton')}
                options={sortOptions}
                value={sortValue}
                onOpen={handleSortTypeClick}
                onChange={handleTypeChange}
            />
        </>
    );
};

export default Sorting;
