const MIN_COUNT_LETTERS_IN_WORD = 14;

interface INeedCutStationsParams {
    stationFrom: string;

    stationTo?: string;
}

interface INeedCutStations {
    needCutStationFrom: boolean;
    needCutStationTo: boolean;
}

/*
    Используется для того, чтобы крассиво обрезать заголовок/строку, фомирующуюся в следующем формате:
    {stationFrom} - {stationTo}

    Например:
    "Сочи - Имеретинский курорт (Олимпийский парк)" => "Сочи - Имеретинский кур..."  вместо "C... - Имеретинский кур..." (... добавляются в css)
    "Имеретинский курорт (Олимпийский парк) - Сочи" => "Имеретинский кур... - Сочи" вмето "Имеретинский кур... - С..."
    "Москва - Тверь" => "Москва - Тве..." в случае, если в строку умещается только 12 символов
    "Москва (Ленинградский вокзал) - Москва (Ленинградский вокзал)" => "Москва... - Москва..."
*/
export default function needCutStations({
    stationFrom,
    stationTo,
}: INeedCutStationsParams): INeedCutStations {
    return {
        needCutStationFrom: stationFrom.length > MIN_COUNT_LETTERS_IN_WORD,
        needCutStationTo:
            stationFrom.length <= MIN_COUNT_LETTERS_IN_WORD ||
            Boolean(stationTo && stationTo.length > MIN_COUNT_LETTERS_IN_WORD),
    };
}
