import ISegment from '../../interfaces/segment/ISegment';
import ISubSegment from '../../interfaces/segment/ISubSegment';

import getDateRobotFromDateMoment from '../../lib/date/getDateRobotFromDateMoment';

interface INeedShowDate {
    departure: boolean;
    arrival: boolean;
}

export default function needShowDate(
    currentSegment: ISegment | ISubSegment,
    prevSegment?: ISegment | ISubSegment,
): INeedShowDate {
    if (!prevSegment) {
        return {
            departure: false,
            arrival: false,
        };
    }

    const {departureLocalDt, arrivalLocalDt} = currentSegment;

    return {
        departure:
            !prevSegment ||
            getDateRobotFromDateMoment(prevSegment.departureLocalDt) !==
                getDateRobotFromDateMoment(departureLocalDt),
        arrival:
            getDateRobotFromDateMoment(prevSegment.arrivalLocalDt) !==
            getDateRobotFromDateMoment(arrivalLocalDt),
    };
}
