import {React, Component, B} from '../base';

import DateHintsLinks from '../DateHintsLinks';
import TransportSelectorLinks from '../TransportSelectorLinks';

const b = B('SearchLinks');

export default class SearchLinks extends Component {
    render() {
        const {sort, time, plans, context, filtering, currencies} = this.props;

        return (
            <div className={b()}>
                <TransportSelectorLinks
                    className={b('transportSelector')}
                    sort={sort}
                    context={context}
                    filtering={filtering}
                    currencies={currencies}
                />

                <div className={b('hints')}>
                    <DateHintsLinks
                        context={context}
                        sort={sort}
                        time={time}
                        plans={plans}
                        filtering={filtering}
                        currencies={currencies}
                    />
                </div>
            </div>
        );
    }
}
