import React, {useCallback, useState} from 'react';
import B from 'bem-cn-lite';

import buildSegmentRenderingData from '../../lib/segments/buildSegmentRenderingData';

import Expander from './components/Expander/Expander';
import SearchSegment from '../SearchSegment/SearchSegment.desktop';

import keyset from '../../i18n/segment';

const b = B('SearchMetaSegment');

const SearchMetaSegment = ({className, data}) => {
    const [opened, setOpened] = useState(false);
    const {segment} = data;
    const {subSegments = [], minArrival, maxArrival} = segment;
    const hasRangeArrivalData = minArrival && minArrival;
    const isRangeArrival = hasRangeArrivalData && minArrival !== maxArrival;
    const hasExpander = !hasRangeArrivalData || isRangeArrival;

    const handleExpand = useCallback(() => {
        setOpened(!opened);
    }, [opened]);

    return (
        <SearchSegment className={b({}, className)} data={data}>
            <td className={b('subsegments')}>
                <table className={b('table')}>
                    <tbody className={b('tbody')}>
                        {opened &&
                            subSegments.map((subSegment, index) => (
                                <SearchSegment
                                    className={b('subsegment')}
                                    key={index}
                                    data={{
                                        ...data,
                                        showTransportIcon: !isRangeArrival,
                                        segment:
                                            buildSegmentRenderingData(
                                                subSegment,
                                            ),
                                    }}
                                />
                            ))}
                    </tbody>
                </table>
            </td>

            {hasExpander && (
                <td className={b('expander')}>
                    <Expander
                        className={b('expanderButton')}
                        title={
                            isRangeArrival
                                ? keyset('expand-segment')
                                : keyset('expand-meta-segment', {
                                      count: subSegments.length,
                                  })
                        }
                        isExpanded={opened}
                        onExpand={handleExpand}
                    />
                </td>
            )}
        </SearchSegment>
    );
};

export default SearchMetaSegment;
