import React, {useCallback, useState} from 'react';
import B from 'bem-cn-lite';

import buildSegmentRenderingData from '../../lib/segments/buildSegmentRenderingData';

import SubSegment from '../SubSegment/SubSegment';
import Expander from './components/Expander/Expander';
import SearchSegment from '../SearchSegment/SearchSegment.mobile';

import keyset from '../../i18n/segment';

const b = B('SearchMetaSegment');

const SearchMetaSegment = ({data}) => {
    const [opened, setOpened] = useState(false);
    const {
        context,
        segment,
        isHidden,
        showArrivalDate,
        showDepartureDate,
        isSuburbanSearchResult,
    } = data;
    const {isGone, minArrival, maxArrival, subSegments = []} = segment;
    const hasRangeArrivalData = minArrival && minArrival;
    const isRangeArrival = hasRangeArrivalData && minArrival !== maxArrival;
    const hasExpander = !hasRangeArrivalData || isRangeArrival;

    const handleExpand = useCallback(() => {
        setOpened(!opened);
    }, [opened]);

    if (isHidden) {
        return null;
    }

    return (
        <div className={b({hasExpander, isGone})}>
            <SearchSegment className={b('parent')} data={data} />

            <div className={b('subsegments')}>
                {opened &&
                    subSegments.map((subSegment, index) =>
                        isRangeArrival ? (
                            <SubSegment
                                className={b('subsegment')}
                                key={index}
                                context={context}
                                segment={subSegment}
                                isSuburbanSearchResult={isSuburbanSearchResult}
                                showArrivalDate={showArrivalDate}
                                showDepartureDate={showDepartureDate}
                            />
                        ) : (
                            <SearchSegment
                                className={b('subsegment')}
                                key={index}
                                data={{
                                    ...data,
                                    segment:
                                        buildSegmentRenderingData(subSegment),
                                }}
                            />
                        ),
                    )}
            </div>

            {hasExpander && (
                <Expander
                    className={b('expanderButton')}
                    title={
                        isRangeArrival
                            ? keyset('expand-segment')
                            : keyset('expand-meta-segment', {
                                  count: subSegments.length,
                              })
                    }
                    isExpanded={opened}
                    onExpand={handleExpand}
                />
            )}
        </div>
    );
};

export default SearchMetaSegment;
