import React from 'react';
import B from 'bem-cn-lite';

import Arrow from '../../../Arrow/Arrow';

interface ITableSegmentExpanderProps {
    title: string;
    isExpanded: boolean;
    onExpand(): void;

    className?: string;
}

const b = B('SegmentExpander');

const SegmentExpander: React.FC<ITableSegmentExpanderProps> = ({
    title,
    isExpanded,
    onExpand,

    className,
}) => {
    return (
        <button className={b({}, className)} onClick={onExpand}>
            {title}

            <Arrow
                className={b('arrow')}
                size="m"
                direction={isExpanded ? 'up' : 'down'}
            />
        </button>
    );
};

export default SegmentExpander;
