import React from 'react';
import B from 'bem-cn-lite';
import {useInView} from 'react-intersection-observer';

import IStatePage from '../../../../interfaces/state/IStatePage';
import IStateFlags from '../../../../interfaces/state/flags/IStateFlags';

import Direct from '../../../Direct/Direct';

interface IMobileFooterDirectProps {
    page: IStatePage;
    flags: IStateFlags;
}

const b = B('MobileFooterDirect');

const DIRECT_ID = 'R-I-239082-63';
const SMARTBANNER_ID = 'Y-A-341252-1';
const DIRECT_ID_EVERLASTING_EXPERIMENT = 'R-I-239082-17';

const MobileFooterDirect: React.FC<IMobileFooterDirectProps> = props => {
    const {page, flags} = props;
    const [ref, wasSeen] = useInView({
        triggerOnce: true,
        rootMargin: '500px',
    });
    const {
        __everlastingSearchTouchExperiment,
        advFooterId,
        idDirectSearchFooterTouch,
    } = flags;
    const directBlockId =
        idDirectSearchFooterTouch ||
        (__everlastingSearchTouchExperiment
            ? DIRECT_ID_EVERLASTING_EXPERIMENT
            : advFooterId ?? DIRECT_ID);

    return (
        <>
            <div ref={ref} />

            {wasSeen && (
                <Direct
                    className={b('footerDirect')}
                    blockId={directBlockId}
                    page={page}
                />
            )}

            <Direct
                blockId={SMARTBANNER_ID}
                format="popup"
                position="relative"
                className={b('smartbanner')}
                page={page}
            />
        </>
    );
};

export default MobileFooterDirect;
