import {TransportType} from '../../../lib/transportType';

import {ISegmentBuyButtonUtmContext} from '../../../contexts/SegmentBuyButtonUtmContext';

const valueForSegmentBuyButtonUtmContext: ISegmentBuyButtonUtmContext = {
    getUtmMedium: (
        transportType,
        isTransferSegment = false,
        isAllDaysSearch = false,
    ) => {
        switch (transportType) {
            case TransportType.train:
                return isTransferSegment
                    ? 'search_transferButton'
                    : 'search_button';
            case TransportType.bus:
                return 'search_segment';
            case TransportType.plane:
                return isAllDaysSearch ? 'alldays_search' : 'redirect';
        }

        return undefined;
    },
};

export default valueForSegmentBuyButtonUtmContext;
