import React from 'react';

import LinksBlock from '../LinksBlock';

import useSelector from '../useSelector';

import popularKeyset from '../../i18n/popular-directions';

interface ISearchPopularDirectionsProps {
    className?: string;
}

const SearchPopularDirections: React.FC<ISearchPopularDirectionsProps> = ({
    className,
}) => {
    const links = useSelector(state => state.search.popularDirectionsLinks);

    if (!links.length) {
        return null;
    }

    return (
        <LinksBlock
            className={className}
            links={links}
            title={popularKeyset('title')}
        />
    );
};

export default SearchPopularDirections;
