import React, {memo, ReactElement} from 'react';
import B from 'bem-cn-lite';

import ISegment from '../../interfaces/segment/ISegment';
import ITransferSegment from '../../interfaces/transfer/ITransferSegment';
import ITransfer from '../../interfaces/transfer/ITransfer';
import ISearchContext from '../../interfaces/state/search/ISearchContext';
import ISearchSort from '../../interfaces/state/search/ISearchSort';

import useSelector from '../useSelector';
import {useFlags} from '../../hooks/useFlags';
import getTariffKeys from '../../lib/segments/getTariffKeys';
import isAllDaysSearchFunc from '../../lib/search/isAllDaysSearch';

import SegmentPrices from '../SegmentPrices/SegmentPrices.mobile';
import SegmentActionButton from '../SegmentActionButton/SegmentActionButton.mobile';

const b = B('SearchPriceBlock');

export default memo(SearchPricesBlock);

interface ISearchPricesBlock {
    segment: ISegment | ITransferSegment | ITransfer;
    context: ISearchContext;
    sort: ISearchSort;
    withActionButton?: boolean;
}

function SearchPricesBlock({
    segment,
    context,
    sort,
    withActionButton = true,
}: ISearchPricesBlock): ReactElement {
    const {isGone} = segment;
    const seoQueryParams = useSelector(state => state.seoQueryParams);
    const flags = useFlags();
    const isAllDaysSearch = isAllDaysSearchFunc(context);
    const {mainTariffKey, tariffKeys: tariffClassKeys} = getTariffKeys(
        segment,
        flags,
        seoQueryParams,
        sort,
    );
    const codeshareCompany = mainTariffKey && mainTariffKey.codeshareCompany;
    const codeshareNumber = mainTariffKey && mainTariffKey.codeshareNumber;

    return (
        <div className={b()}>
            <div className={b('priceContainer')}>
                {codeshareCompany && (
                    <div className={b('codeshare')}>
                        {codeshareNumber}
                        <span className={b('codeshareTitle')}>
                            {codeshareCompany.title ||
                                codeshareCompany.shortTitle}
                        </span>
                    </div>
                )}

                <SegmentPrices
                    segment={segment}
                    tariffClassKeys={tariffClassKeys}
                    isAllDaysSearch={isAllDaysSearch}
                />
            </div>

            {!isGone && withActionButton && (
                <SegmentActionButton
                    segment={segment}
                    tariffClassKeys={tariffClassKeys}
                    context={context}
                    className={b('actionButton')}
                    mainTariffKey={mainTariffKey || undefined}
                />
            )}
        </div>
    );
}
