import React from 'react';
import B from 'bem-cn-lite';
import get from 'lodash/get';
import {momentTimezone as moment} from '../../../../../reexports';

import IStateFlags from '../../../../interfaces/state/flags/IStateFlags';
import ISegmentTransport from '../../../../interfaces/segment/ISegmentTransport';
import IDurationRoundingOptions from '../../../../interfaces/date/IDurationRoundingOptions';

import {humanizeDuration} from '../../../../lib/date/formats';

const b = B('TableDuration');

interface ITableDurationProps {
    className?: string;
    duration: number;
    prefix?: string;
    postfix?: string;
    description?: string;
    isExpress?: boolean;
    transport?: ISegmentTransport;
    durationOpts?: Partial<IDurationRoundingOptions>;
    flags?: IStateFlags;
}

const TableDuration: React.FC<ITableDurationProps> = ({
    className,
    duration,
    postfix,
    prefix,
    description,
    transport,
    durationOpts = {},
    isExpress,
    flags,
}) => {
    const durationMoment = moment.duration(duration, 'seconds');

    const color = isExpress && get(transport, 'subtype.titleColor');
    const style = color ? {color} : {};

    const flagsOptions: Partial<IDurationRoundingOptions> = {};

    if (flags && flags.__ufsTesting) {
        flagsOptions.maxUnits = 3;
    }

    return (
        <div className={b({}, className)} style={style}>
            {prefix && <span>{prefix} </span>}
            {humanizeDuration(durationMoment, {
                ...durationOpts,
                ...flagsOptions,
            })}
            {description && (
                <div className={b('durationDescription')}>{description}</div>
            )}
            {postfix && <span> {postfix}</span>}
        </div>
    );
};

export default TableDuration;
