import React, {RefObject} from 'react';
import {ClassName} from 'bem-cn-lite';

import ISegmentStation from '../../../../interfaces/segment/ISegmentStation';
import StationSubtype from '../../../../interfaces/state/station/StationSubtype';
import IPoint from '../../../../interfaces/state/searchForm/IPoint';

import Station from '../Station/Station';

interface ITablePointProps {
    b: ClassName;
    city: IPoint | null;
    station: ISegmentStation;
    stationIsVisible: boolean;
    stationSubtype: StationSubtype;

    useCityInsteadStation?: boolean;
    dataNoSnippet?: boolean;
    pointRef?: RefObject<HTMLDivElement>;
    stationOpacity?: 0 | 1;
    className?: string;
}

const TablePoint: React.FC<ITablePointProps> = ({
    b,
    city,
    station,
    stationIsVisible,
    stationSubtype,

    useCityInsteadStation = false,
    dataNoSnippet = false,
    pointRef,
    stationOpacity,
    className,
}) => {
    if (useCityInsteadStation && city) {
        return (
            <div
                className={b('stationHolder', {}, className)}
                data-nosnippet={dataNoSnippet || undefined}
                ref={pointRef}
                style={{opacity: stationOpacity}}
            >
                {city.popularTitle || city.title}
            </div>
        );
    }

    return (
        <Station
            station={station}
            stationIsVisible={stationIsVisible}
            stationSubtype={stationSubtype}
            className={b('station', {}, className)}
            dataNoSnippet={dataNoSnippet}
            stationRef={pointRef}
            stationOpacity={stationOpacity}
        />
    );
};

export default React.memo(TablePoint);
