import React, {PureComponent, ReactHTML} from 'react';
import B from 'bem-cn-lite';

import Lang from '../../../../interfaces/Lang';
import ISearchContext from '../../../../interfaces/state/search/ISearchContext';
import IStateCurrencies from '../../../../interfaces/state/IStateCurrencies';

import {getToday} from '../../../../lib/date/utils';
import {maskToString} from '../../../../lib/date/stringifyMask';
import checkIsAllDaysSearch from '../../../../lib/search/isAllDaysSearch';

import ModalChoosePartner from '../../../ModalChoosePartner';
import SegmentPrices from '../../../SegmentPrices/SegmentPrices.desktop';

import segmentKeyset from '../../../../i18n/segment';

interface ITableScheduleAndPricesProps {
    // TODO: Необходим тип для пропатченного сегмента
    segment: any;
    // TODO: В ISegmentTariffClass не описано поле variants
    klass: any;
    context: ISearchContext;
    tariffClassKeys: string[];
    withActionButton?: boolean;
    language: Lang;
    tag?: keyof ReactHTML;
    queryingPrices: boolean;
    currencies: IStateCurrencies;
}

interface ITableScheduleAndPricesState {
    partnerPickerShown: boolean;
}

const b = B('TableScheduleAndPrices');

export default class TableScheduleAndPrices extends PureComponent<
    ITableScheduleAndPricesProps,
    ITableScheduleAndPricesState
> {
    state = {
        partnerPickerShown: false,
    };

    openPartnerPicker = (e): void => {
        if (e) {
            e.preventDefault();
        }

        this.setState({partnerPickerShown: !this.state.partnerPickerShown});
    };

    getModalChoosePartner = (): React.ReactNode => {
        const {segment, language, klass} = this.props;

        return (
            <ModalChoosePartner
                tariffClass={klass}
                segment={segment}
                language={language}
                togglePartnerPicker={this.openPartnerPicker}
            />
        );
    };

    render(): React.ReactNode {
        const {
            tag,
            context,
            currencies,
            queryingPrices,
            tariffClassKeys,
            klass,
            segment,
            withActionButton = true,
        } = this.props;

        const {isGone, runDays, isMerged, stationFrom, daysByTimezone} =
            segment;

        const {timezone} = stationFrom;
        const {variants} = klass || {};

        const days = isMerged
            ? runDays && {
                  text: maskToString(runDays, getToday(context), timezone),
              }
            : daysByTimezone && daysByTimezone[timezone];

        const Component = tag || 'div';

        if (isGone) {
            return (
                <Component className={b()}>
                    <div className={b('goneWrapper')}>
                        <span className={b('warningTitle')}>
                            {segmentKeyset('gone-title')}
                        </span>
                    </div>
                </Component>
            );
        }

        const outOfSeats = Boolean(klass && klass.seats === 0);

        if (outOfSeats) {
            return null;
        }

        const isAllDaysSearch = checkIsAllDaysSearch(context);

        return (
            <>
                {days && (
                    <Component className={b('scheduleDays')}>
                        {days.schedulePlanAppendix ? (
                            <span>
                                {days.shortText}{' '}
                                <span className={b('schedulePlanAppendix')}>
                                    {days.schedulePlanAppendix}
                                </span>
                            </span>
                        ) : (
                            days.text
                        )}
                        {days.exceptText && (
                            <div className={b('exceptDays')}>
                                {segmentKeyset('except-days', {
                                    days: days.exceptText,
                                })}
                            </div>
                        )}
                    </Component>
                )}

                <Component className={b('prices')}>
                    <SegmentPrices
                        className={b('pricesContent')}
                        klass={klass}
                        segment={segment}
                        queryingPrices={queryingPrices}
                        tariffClassKeys={tariffClassKeys}
                        withActionButton={withActionButton}
                        context={context}
                        currencies={currencies}
                        isAllDaysSearch={isAllDaysSearch}
                        openPartnerPicker={this.openPartnerPicker}
                    />
                </Component>

                {variants &&
                    this.state.partnerPickerShown &&
                    this.getModalChoosePartner()}
            </>
        );
    }
}
