import React, {PureComponent} from 'react';
import B from 'bem-cn-lite';
import {Moment} from 'moment';

import ISearchContext from '../../../../interfaces/state/search/ISearchContext';

import {reachGoalOnce} from '../../../../lib/yaMetrika';

import Dropdown from '../../../Dropdown/Dropdown';
import SegmentTitle from '../../../SegmentTitle/SegmentTitle.desktop';
import SegmentInformer from '../../../SegmentInformer/SegmentInformer';
import SuburbanFacilities from '../../../SuburbanFacilities/SuburbanFacilities';

import keyset from '../../../../i18n/segment';

interface ISegmentHeaderProps {
    segment: any;
    context: ISearchContext;
    className?: string;
    currentTimeMoment: Moment;
    showTransportIcon: boolean;
    isSuburbanSearchResult: boolean;
}

const b = B('SegmentHeader');

export default class SegmentHeader extends PureComponent<ISegmentHeaderProps> {
    componentDidMount(): void {
        const {segment} = this.props;
        const {thread} = segment;

        if (thread && thread.comment) {
            reachGoalOnce('segment_comment_shown');
        }
    }

    onCommentOpen(): void {
        reachGoalOnce('segment_comment_click');
    }

    render(): React.ReactNode {
        const {
            className,
            segment,
            context,
            currentTimeMoment,
            showTransportIcon,
            isSuburbanSearchResult,
        } = this.props;

        const {thread, suburbanFacilities} = segment;

        return (
            <td className={b({}, className)}>
                <SegmentInformer
                    segment={segment}
                    currentTimeMoment={currentTimeMoment}
                />

                <SegmentTitle
                    context={context}
                    segment={segment}
                    showTransportIcon={showTransportIcon}
                    isSuburbanSearchResult={isSuburbanSearchResult}
                />

                {isSuburbanSearchResult && suburbanFacilities && (
                    <SuburbanFacilities
                        suburbanFacilities={suburbanFacilities}
                    />
                )}

                {thread && thread.comment && (
                    <Dropdown
                        className={b('commentButton')}
                        noArrow
                        onOpen={this.onCommentOpen}
                        buttonText={keyset('details')}
                    >
                        <div
                            className={b('comment')}
                            dangerouslySetInnerHTML={{__html: thread.comment}}
                        />
                    </Dropdown>
                )}
            </td>
        );
    }
}
