import React, {RefObject} from 'react';
import B from 'bem-cn-lite';

import ISegmentStation from '../../../../interfaces/segment/ISegmentStation';
import StationSubtype from '../../../../interfaces/state/station/StationSubtype';
import {IWithClassName} from '../../../../interfaces/components/IWithClassName';

import {stationUrl} from '../../../../lib/url/stationUrl';
import useSelector from '../../../useSelector';

import Link from '../../../Link';

interface ITableStation extends IWithClassName {
    station: ISegmentStation;
    stationIsVisible: boolean;
    stationSubtype: StationSubtype; // subtype для которого формировать ссылку

    dataNoSnippet?: boolean;
    stationRef?: RefObject<HTMLDivElement>;
    stationOpacity?: 0 | 1;
}

const b = B('TableStation');

const TableStation: React.FC<ITableStation> = ({
    station,
    stationIsVisible,
    stationSubtype,

    className,
    dataNoSnippet,
    stationRef,
    stationOpacity = 1,
}) => {
    const tld = useSelector(state => state.tld);
    const language = useSelector(state => state.language);

    return (
        <div
            className={b({}, className)}
            data-nosnippet={dataNoSnippet || undefined}
            ref={stationRef}
            style={{opacity: stationOpacity}}
        >
            {stationIsVisible && (
                <Link
                    className={b('station')}
                    href={stationUrl({
                        id: station.id,
                        mainSubtype: station.mainSubtype,
                        // Если не изветсен mainSubtype, то не передаем subtype, потому что некотрые ручки тарифов
                        // ничего не знают про mainSubtype и если добавлять subtype, то может быть 302-редирект на странице станции
                        subtype: station.mainSubtype
                            ? stationSubtype
                            : undefined,
                        isMobile: false,
                        tld,
                        language,
                    })}
                >
                    {station.popularTitle || station.title}
                </Link>
            )}

            {station.platform && (
                <div className={b('platform')}>{station.platform}</div>
            )}
        </div>
    );
};

export default React.memo(TableStation);
